/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base;

import java.lang.reflect.Method;
import org.jfree.base.BootableProjectInfo;
import org.jfree.base.Library;
import org.jfree.base.modules.PackageManager;
import org.jfree.base.modules.SubSystem;
import org.jfree.util.Configuration;
import org.jfree.util.Log;

public abstract class AbstractBoot
implements SubSystem {
    private PackageManager packageManager;
    private Configuration globalConfig;
    private boolean bootInProgress;
    private boolean bootDone;

    public synchronized PackageManager getPackageManager() {
        if (this.packageManager == null) {
            this.packageManager = PackageManager.createInstance(this);
        }
        return this.packageManager;
    }

    public synchronized Configuration getGlobalConfig() {
        if (this.globalConfig == null) {
            this.globalConfig = this.loadConfiguration();
            this.start();
        }
        return this.globalConfig;
    }

    public boolean isBootInProgress() {
        return this.bootInProgress;
    }

    public boolean isBootDone() {
        return this.bootDone;
    }

    protected abstract Configuration loadConfiguration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this;
        synchronized (this) {
            BootableProjectInfo[] bootableProjectInfoArray;
            if (this.isBootInProgress() || this.isBootDone()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.bootInProgress = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            object = this.getProjectInfo();
            if (object != null) {
                Log.info(((Library)object).getName() + " " + ((Library)object).getVersion());
                bootableProjectInfoArray = ((BootableProjectInfo)object).getDependencies();
                for (int i = 0; i < bootableProjectInfoArray.length; ++i) {
                    AbstractBoot abstractBoot = this.loadBooter(bootableProjectInfoArray[i].getBootClass());
                    if (abstractBoot == null) continue;
                    abstractBoot.start();
                }
            }
            this.performBoot();
            bootableProjectInfoArray = this;
            synchronized (this) {
                this.bootInProgress = false;
                this.bootDone = true;
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return;
            }
        }
    }

    protected abstract void performBoot();

    protected abstract BootableProjectInfo getProjectInfo();

    protected AbstractBoot loadBooter(String string) {
        if (string == null) {
            return null;
        }
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(string);
            Method method = clazz.getMethod("getInstance", null);
            return (AbstractBoot)method.invoke(null, null);
        }
        catch (Exception exception) {
            Log.info("Unable to boot dependent class: " + string);
            return null;
        }
    }
}

