/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jfree.text.TextUtilities;
import org.jfree.ui.NumberCellRenderer;
import org.jfree.ui.TextAnchor;
import org.jfree.util.Log;
import org.jfree.util.LogContext;
import org.jfree.util.ShapeUtilities;

public abstract class RefineryUtilities {
    protected static final LogContext logger = Log.createContext(class$org$jfree$ui$RefineryUtilities == null ? (class$org$jfree$ui$RefineryUtilities = RefineryUtilities.class$("org.jfree.ui.RefineryUtilities")) : class$org$jfree$ui$RefineryUtilities);
    static /* synthetic */ Class class$org$jfree$ui$RefineryUtilities;
    static /* synthetic */ Class class$java$lang$Number;

    public static void centerFrameOnScreen(Window window) {
        RefineryUtilities.positionFrameOnScreen(window, 0.5, 0.5);
    }

    public static void positionFrameOnScreen(Window window, double d, double d2) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = window.getSize();
        int n = Math.max(dimension.width - dimension2.width, 0);
        int n2 = Math.max(dimension.height - dimension2.height, 0);
        int n3 = (int)(d * (double)n);
        int n4 = (int)(d2 * (double)n2);
        window.setBounds(n3, n4, dimension2.width, dimension2.height);
    }

    public static void positionFrameRandomly(Window window) {
        RefineryUtilities.positionFrameOnScreen(window, Math.random(), Math.random());
    }

    public static void centerDialogInParent(Dialog dialog) {
        RefineryUtilities.positionDialogRelativeToParent(dialog, 0.5, 0.5);
    }

    public static void positionDialogRelativeToParent(Dialog dialog, double d, double d2) {
        Dimension dimension = dialog.getSize();
        Container container = dialog.getParent();
        Dimension dimension2 = container.getSize();
        int n = container.getX() - dimension.width;
        int n2 = container.getY() - dimension.height;
        int n3 = dimension.width + dimension2.width;
        int n4 = dimension.height + dimension2.height;
        int n5 = n + (int)(d * (double)n3);
        int n6 = n2 + (int)(d2 * (double)n4);
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        n5 = Math.min(n5, dimension3.width - dimension.width);
        n5 = Math.max(n5, 0);
        n6 = Math.min(n6, dimension3.height - dimension.height);
        n6 = Math.max(n6, 0);
        dialog.setBounds(n5, n6, dimension.width, dimension.height);
    }

    public static JPanel createTablePanel(TableModel tableModel) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTable jTable = new JTable(tableModel);
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
            Class<?> clazz = tableModel.getColumnClass(i);
            if (!clazz.equals(class$java$lang$Number == null ? RefineryUtilities.class$("java.lang.Number") : class$java$lang$Number)) continue;
            tableColumn.setCellRenderer(new NumberCellRenderer());
        }
        jPanel.add(new JScrollPane(jTable));
        return jPanel;
    }

    public static JLabel createJLabel(String string, Font font) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(font);
        return jLabel;
    }

    public static JLabel createJLabel(String string, Font font, Color color) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(font);
        jLabel.setForeground(color);
        return jLabel;
    }

    public static JButton createJButton(String string, Font font) {
        JButton jButton = new JButton(string);
        jButton.setFont(font);
        return jButton;
    }

    public static Point2D getPointInRectangle(double d, double d2, Rectangle2D rectangle2D) {
        d = Math.max(rectangle2D.getMinX(), Math.min(d, rectangle2D.getMaxX()));
        d2 = Math.max(rectangle2D.getMinY(), Math.min(d2, rectangle2D.getMaxY()));
        return new Point2D.Double(d, d2);
    }

    public static void drawRotatedShape(Shape shape, Graphics2D graphics2D, float f, float f2, double d) {
        ShapeUtilities.drawRotatedShape(graphics2D, shape, d, f, f2);
    }

    public static void drawAlignedString(String string, Graphics2D graphics2D, float f, float f2, TextAnchor textAnchor) {
        TextUtilities.drawAlignedString(string, graphics2D, f, f2, textAnchor);
    }

    public static void drawRotatedString(String string, Graphics2D graphics2D, float f, float f2, double d) {
        TextUtilities.drawRotatedString(string, graphics2D, f, f2, d, f, f2);
    }

    public static Shape calculateRotatedStringBounds(String string, Graphics2D graphics2D, float f, float f2, double d, float f3, float f4) {
        return TextUtilities.calculateRotatedStringBounds(string, graphics2D, f, f2, d, f3, f4);
    }

    public static void drawRotatedString(String string, Graphics2D graphics2D, float f, float f2, double d, float f3, float f4) {
        TextUtilities.drawRotatedString(string, graphics2D, f, f2, d, f3, f4);
    }

    public static void drawRotatedString(String string, Graphics2D graphics2D, float f, float f2, TextAnchor textAnchor, float f3, float f4, double d) {
        TextUtilities.drawRotatedString(string, graphics2D, f, f2, textAnchor, d, f3, f4);
    }

    public static void drawRotatedString(String string, Graphics2D graphics2D, float f, float f2, TextAnchor textAnchor, TextAnchor textAnchor2, double d) {
        TextUtilities.drawRotatedString(string, graphics2D, f, f2, textAnchor, d, textAnchor2);
    }

    public static Shape calculateRotatedStringBounds(String string, Graphics2D graphics2D, float f, float f2, TextAnchor textAnchor, TextAnchor textAnchor2, double d) {
        return TextUtilities.calculateRotatedStringBounds(string, graphics2D, f, f2, textAnchor, d, textAnchor2);
    }

    public static void setUseDrawRotatedStringWorkaround(boolean bl) {
        TextUtilities.setUseDrawRotatedStringWorkaround(bl);
    }

    public static boolean invokeAndWait(Runnable runnable) throws InterruptedException {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

