/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import org.jfree.util.Log;

public abstract class ResourceBundleSupport {
    private ResourceBundle resources;
    private TreeMap cache;
    private TreeSet lookupPath;
    private String resourceBase;
    static /* synthetic */ Class class$java$awt$event$KeyEvent;

    protected ResourceBundleSupport(String string) {
        this.resources = ResourceBundle.getBundle(string);
        this.resourceBase = string;
        this.cache = new TreeMap();
        this.lookupPath = new TreeSet();
    }

    protected final String getResourceBase() {
        return this.resourceBase;
    }

    public synchronized String getString(String string) {
        String string2 = (String)this.cache.get(string);
        if (string2 != null) {
            return string2;
        }
        this.lookupPath.clear();
        return this.internalGetString(string);
    }

    protected String internalGetString(String string) {
        if (this.lookupPath.contains(string)) {
            throw new MissingResourceException("InfiniteLoop in resource lookup", this.getResourceBase(), this.lookupPath.toString());
        }
        String string2 = this.resources.getString(string);
        if (string2.startsWith("@@")) {
            int n = string2.indexOf(64, 2);
            if (n == -1) {
                throw new MissingResourceException("Invalid format for global lookup key.", this.getResourceBase(), string);
            }
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(string2.substring(2, n));
                return resourceBundle.getString(string2.substring(n + 1));
            }
            catch (Exception exception) {
                Log.error("Error during global lookup", exception);
                throw new MissingResourceException("Error during global lookup", this.getResourceBase(), string);
            }
        }
        if (string2.startsWith("@")) {
            String string3 = string2.substring(1);
            this.lookupPath.add(string);
            String string4 = this.internalGetString(string3);
            this.cache.put(string, string4);
            return string4;
        }
        this.cache.put(string, string2);
        return string2;
    }

    public Icon getIcon(String string, boolean bl) {
        String string2 = this.getString(string);
        return this.createIcon(string2, true, bl);
    }

    public Icon getIcon(String string) {
        String string2 = this.getString(string);
        return this.createIcon(string2, false, false);
    }

    public Integer getMnemonic(String string) {
        String string2 = this.getString(string);
        return this.createMnemonic(string2);
    }

    public KeyStroke getKeyStroke(String string) {
        String string2 = this.getString(string);
        return this.createMenuKeystroke(string2);
    }

    public JMenu createMenu(String string) {
        JMenu jMenu = new JMenu();
        jMenu.setText(this.getString(string + ".name"));
        jMenu.setMnemonic(this.getMnemonic(string + ".mnemonic"));
        return jMenu;
    }

    public URL getResourceURL(String string) {
        String string2 = this.getString(string);
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string2);
        if (uRL == null) {
            Log.warn("Unable to find file in the class path: " + string2 + "; key=" + string);
        }
        return uRL;
    }

    private ImageIcon createIcon(String string, boolean bl, boolean bl2) {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        if (uRL == null) {
            Log.warn("Unable to find file in the class path: " + string);
            return new ImageIcon(this.createTransparentImage(1, 1));
        }
        Image image = Toolkit.getDefaultToolkit().createImage(uRL);
        if (image == null) {
            Log.warn("Unable to instantiate the image: " + string);
            return new ImageIcon(this.createTransparentImage(1, 1));
        }
        if (bl) {
            if (bl2) {
                return new ImageIcon(image.getScaledInstance(24, 24, 4));
            }
            return new ImageIcon(image.getScaledInstance(16, 16, 4));
        }
        return new ImageIcon(image);
    }

    private final KeyStroke createMenuKeystroke(String string) {
        return KeyStroke.getKeyStroke(this.createMnemonic(string), this.getMenuKeyMask());
    }

    private Integer createMnemonic(String string) {
        if (string == null) {
            throw new NullPointerException("Key is null.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Key is empty.");
        }
        int n = string.charAt(0);
        if (string.startsWith("VK_")) {
            try {
                Field field = (class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = ResourceBundleSupport.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent).getField(string);
                Integer n2 = (Integer)field.get(null);
                n = n2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Integer(n);
    }

    private int getMenuKeyMask() {
        try {
            return Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return 2;
        }
    }

    private BufferedImage createTransparentImage(int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        int[] nArray = bufferedImage.getRGB(0, 0, n, n2, null, 0, n);
        Arrays.fill(nArray, 0);
        bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
        return bufferedImage;
    }

    public Icon createTransparentIcon(int n, int n2) {
        return new ImageIcon(this.createTransparentImage(n, n2));
    }

    public String formatMessage(String string, Object object) {
        return MessageFormat.format(this.getString(string), object);
    }

    public String formatMessage(String string, Object object, Object object2) {
        return MessageFormat.format(this.getString(string), object, object2);
    }

    public String formatMessage(String string, Object[] objectArray) {
        return MessageFormat.format(this.getString(string), objectArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

