/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Arrays;

public abstract class ShapeUtils {
    private static final float SQRT2 = (float)Math.pow(2.0, 0.5);

    public static Shape clone(Shape shape) {
        Shape shape2 = null;
        if (shape instanceof Line2D) {
            Line2D line2D = (Line2D)shape;
            shape2 = (Shape)line2D.clone();
        } else if (shape instanceof RectangularShape) {
            RectangularShape rectangularShape = (RectangularShape)shape;
            shape2 = (Shape)rectangularShape.clone();
        } else if (shape instanceof Area) {
            Area area = (Area)shape;
            shape2 = (Shape)area.clone();
        } else if (shape instanceof GeneralPath) {
            GeneralPath generalPath = (GeneralPath)shape;
            shape2 = (Shape)generalPath.clone();
        }
        return shape2;
    }

    public static boolean equal(Polygon polygon, Polygon polygon2) {
        if (polygon == null) {
            return polygon2 == null;
        }
        if (polygon2 == null) {
            return false;
        }
        if (polygon.npoints != polygon2.npoints) {
            return false;
        }
        if (!Arrays.equals(polygon.xpoints, polygon2.xpoints)) {
            return false;
        }
        return Arrays.equals(polygon.ypoints, polygon2.ypoints);
    }

    public static Shape translateShape(Shape shape, double d, double d2) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d, d2);
        return affineTransform.createTransformedShape(shape);
    }

    public static Shape rotateShape(Shape shape, double d, float f, float f2) {
        if (shape == null) {
            return null;
        }
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d, f, f2);
        Shape shape2 = affineTransform.createTransformedShape(shape);
        return shape2;
    }

    public static void drawRotatedShape(Graphics2D graphics2D, Shape shape, double d, float f, float f2) {
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = AffineTransform.getRotateInstance(d, f, f2);
        graphics2D.transform(affineTransform2);
        graphics2D.draw(shape);
        graphics2D.setTransform(affineTransform);
    }

    public static Shape createDiagonalCross(float f, float f2) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(-f - f2, -f + f2);
        generalPath.lineTo(-f + f2, -f - f2);
        generalPath.lineTo(0.0f, -f2 * SQRT2);
        generalPath.lineTo(f - f2, -f - f2);
        generalPath.lineTo(f + f2, -f + f2);
        generalPath.lineTo(f2 * SQRT2, 0.0f);
        generalPath.lineTo(f + f2, f - f2);
        generalPath.lineTo(f - f2, f + f2);
        generalPath.lineTo(0.0f, f2 * SQRT2);
        generalPath.lineTo(-f + f2, f + f2);
        generalPath.lineTo(-f - f2, f - f2);
        generalPath.lineTo(-f2 * SQRT2, 0.0f);
        generalPath.closePath();
        return generalPath;
    }

    public static Shape createRegularCross(float f, float f2) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(-f, f2);
        generalPath.lineTo(-f2, f2);
        generalPath.lineTo(-f2, f);
        generalPath.lineTo(f2, f);
        generalPath.lineTo(f2, f2);
        generalPath.lineTo(f, f2);
        generalPath.lineTo(f, -f2);
        generalPath.lineTo(f2, -f2);
        generalPath.lineTo(f2, -f);
        generalPath.lineTo(-f2, -f);
        generalPath.lineTo(-f2, -f2);
        generalPath.lineTo(-f, -f2);
        generalPath.closePath();
        return generalPath;
    }

    public static Shape createDiamond(float f) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, -f);
        generalPath.lineTo(f, 0.0f);
        generalPath.lineTo(0.0f, f);
        generalPath.lineTo(-f, 0.0f);
        generalPath.closePath();
        return generalPath;
    }

    public static Shape createUpTriangle(float f) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, -f);
        generalPath.lineTo(f, f);
        generalPath.lineTo(-f, f);
        generalPath.closePath();
        return generalPath;
    }

    public static Shape createDownTriangle(float f) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, f);
        generalPath.lineTo(f, -f);
        generalPath.lineTo(-f, -f);
        generalPath.closePath();
        return generalPath;
    }

    public static Shape createLineRegion(Line2D line2D, float f) {
        GeneralPath generalPath = new GeneralPath();
        float f2 = (float)line2D.getX1();
        float f3 = (float)line2D.getX2();
        float f4 = (float)line2D.getY1();
        float f5 = (float)line2D.getY2();
        if ((double)(f3 - f2) != 0.0) {
            double d = Math.atan((f5 - f4) / (f3 - f2));
            float f6 = (float)Math.sin(d) * f;
            float f7 = (float)Math.cos(d) * f;
            generalPath.moveTo(f2 - f6, f4 + f7);
            generalPath.lineTo(f2 + f6, f4 - f7);
            generalPath.lineTo(f3 + f6, f5 - f7);
            generalPath.lineTo(f3 - f6, f5 + f7);
            generalPath.closePath();
        } else {
            generalPath.moveTo(f2 - f / 2.0f, f4);
            generalPath.lineTo(f2 + f / 2.0f, f4);
            generalPath.lineTo(f3 + f / 2.0f, f5);
            generalPath.lineTo(f3 - f / 2.0f, f5);
            generalPath.closePath();
        }
        return generalPath;
    }

    public static Point2D getPointInRectangle(double d, double d2, Rectangle2D rectangle2D) {
        d = Math.max(rectangle2D.getMinX(), Math.min(d, rectangle2D.getMaxX()));
        d2 = Math.max(rectangle2D.getMinY(), Math.min(d2, rectangle2D.getMaxY()));
        return new Point2D.Double(d, d2);
    }
}

