/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import org.jfree.util.Configuration;
import org.jfree.util.DefaultConfiguration;
import org.jfree.xml.CommentHandler;
import org.jfree.xml.ElementDefinitionHandler;
import org.jfree.xml.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class Parser
extends DefaultHandler
implements Configuration {
    public static final String CONTENTBASE_KEY = "content-base";
    private Stack activeFactories = new Stack();
    private ElementDefinitionHandler initialFactory;
    private DefaultConfiguration parserConfiguration = new DefaultConfiguration();
    private HashMap parserHelperObjects = new HashMap();
    private Locator locator;
    private final CommentHandler commentHandler = new CommentHandler();

    public CommentHandler getCommentHandler() {
        return this.commentHandler;
    }

    public String[] getComments() {
        return this.getCommentHandler().getComments();
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void pushFactory(ElementDefinitionHandler elementDefinitionHandler) {
        this.activeFactories.push(elementDefinitionHandler);
    }

    public ElementDefinitionHandler peekFactory() {
        return (ElementDefinitionHandler)this.activeFactories.peek();
    }

    public ElementDefinitionHandler popFactory() {
        this.activeFactories.pop();
        return this.peekFactory();
    }

    public void endDocument() throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.activeFactories.clear();
        this.pushFactory(this.getInitialFactory());
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.peekFactory().characters(cArray, n, n2);
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (Exception exception) {
            throw new ParseException(exception, this.getLocator());
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this.peekFactory().endElement(string3);
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (Exception exception) {
            throw new ParseException(exception, this.getLocator());
        }
        finally {
            this.getCommentHandler().clearComments();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            this.peekFactory().startElement(string3, attributes);
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (Exception exception) {
            throw new ParseException(exception, this.getLocator());
        }
        finally {
            this.getCommentHandler().clearComments();
        }
    }

    public void setInitialFactory(ElementDefinitionHandler elementDefinitionHandler) {
        this.initialFactory = elementDefinitionHandler;
    }

    public ElementDefinitionHandler getInitialFactory() {
        return this.initialFactory;
    }

    public String getConfigProperty(String string) {
        return this.getConfigProperty(string, null);
    }

    public String getConfigProperty(String string, String string2) {
        return this.parserConfiguration.getConfigProperty(string, string2);
    }

    public void setConfigProperty(String string, String string2) {
        if (string2 == null) {
            this.parserConfiguration.remove(string);
        } else {
            this.parserConfiguration.setProperty(string, string2);
        }
    }

    public void setHelperObject(String string, Object object) {
        if (object == null) {
            this.parserHelperObjects.remove(string);
        } else {
            this.parserHelperObjects.put(string, object);
        }
    }

    public Object getHelperObject(String string) {
        return this.parserHelperObjects.get(string);
    }

    public abstract Parser getInstance();

    public abstract Object getResult();

    public Iterator findPropertyKeys(String string) {
        return this.parserConfiguration.findPropertyKeys(string);
    }
}

